/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp2;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import cz.insophy.inplan.mrp2.Demand;
import cz.insophy.inplan.mrp2.MatChange;
import cz.insophy.inplan.mrp2.MaterialChanges;
import cz.insophy.inplan.mrp2.Pairing;
import cz.insophy.inplan.mrp2.PairingAlgorithm;
import cz.insophy.inplan.mrp2.SortKeyExtractor;
import cz.insophy.inplan.mrp2.Supply;
import cz.insophy.inplan.mrp2.SupplyCreationException;
import cz.insophy.inplan.mrp2.SupplyFactory;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.util.Comparators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedPairingAlgorithm<SK extends Comparable<SK>>
implements PairingAlgorithm {
    private static final Logger log = LoggerFactory.getLogger(SortedPairingAlgorithm.class);
    protected final SortKeyExtractor<SK> skExtractor;
    protected final ChangeComparator chComp;

    public SortedPairingAlgorithm(SortKeyExtractor<SK> skExtractor) {
        this.skExtractor = Preconditions.checkNotNull(skExtractor);
        this.chComp = new ChangeComparator();
    }

    @Override
    @Nonnull
    public Pairing createPairing(@Nonnull MaterialChanges changes) {
        List<Demand> demands = changes.getDemands();
        List<Supply> supplies = changes.getSupplies();
        Collections.sort(demands, this.chComp);
        Collections.sort(supplies, this.chComp);
        SortedPairing pairing = new SortedPairing(changes.getMaterial(), supplies, demands);
        pairing.completeSupPairing();
        return pairing;
    }

    protected class ChangeComparator
    implements Comparator<MatChange> {
        protected ChangeComparator() {
        }

        @Override
        public int compare(MatChange o1, MatChange o2) {
            Object sk1 = o1.getSortKey(SortedPairingAlgorithm.this.skExtractor);
            Object sk2 = o2.getSortKey(SortedPairingAlgorithm.this.skExtractor);
            return sk1.compareTo(sk2);
        }
    }

    protected class SortedPairing
    implements Pairing {
        protected final ListMultimap<Demand, Supply> demToSup;
        protected final ListMultimap<Supply, Demand> supToDem;
        protected final List<Demand> demands;
        protected final List<Supply> supplies;
        protected final Material material;
        protected int lastPairedDem;
        protected int lastPairedSup;
        protected double lastDemFilledQty;
        protected double lastSupUsedQty;

        public SortedPairing(@Nonnull Material material, @Nonnull List<Supply> supplies, List<Demand> demands) {
            this.material = material;
            Preconditions.checkNotNull(supplies);
            Preconditions.checkNotNull(demands);
            this.demToSup = ArrayListMultimap.create();
            this.supToDem = ArrayListMultimap.create();
            this.supplies = supplies;
            this.demands = demands;
            this.lastPairedSup = -1;
            this.lastPairedDem = -1;
            this.lastDemFilledQty = 0.0;
            this.lastSupUsedQty = 0.0;
        }

        @Override
        @Nonnull
        public List<Demand> getDemands(@Nonnull Supply supply) {
            return this.supToDem.get((Object)supply);
        }

        @Override
        @Nonnull
        public List<Supply> getSupplies(@Nonnull Demand demand) {
            return this.demToSup.get((Object)demand);
        }

        @Override
        @Nonnull
        public List<Supply> getAllSupplies() {
            return this.supplies;
        }

        protected Material getMaterial() {
            return this.material;
        }

        protected void addSupply(Supply supply) {
            this.supplies.add(supply);
        }

        protected void addPairing(int demandIdx, int supplyIdx) {
            Demand demand = this.demands.get(demandIdx);
            Supply supply = this.supplies.get(supplyIdx);
            this.demToSup.put(demand, supply);
            this.supToDem.put(supply, demand);
        }

        protected void completeSupPairing() {
            if (this.lastPairedSup == this.supplies.size() - 1) {
                return;
            }
            block0: for (int i = this.lastPairedSup + 1; i < this.supplies.size() && this.lastPairedDem != this.demands.size() - 1; ++i) {
                Supply supply = this.supplies.get(i);
                for (int j = this.lastPairedDem + 1; j < this.demands.size(); ++j) {
                    Demand demand = this.demands.get(j);
                    this.addPairing(j, i);
                    double supQtyLeft = supply.getQty() - this.lastSupUsedQty;
                    double demQtyLeft = demand.getQty() - this.lastDemFilledQty;
                    if (Comparators.compare(supQtyLeft, demQtyLeft, 1.0E-7) > 0) {
                        this.lastSupUsedQty += demQtyLeft;
                        this.lastDemFilledQty = 0.0;
                        ++this.lastPairedDem;
                        continue;
                    }
                    if (Comparators.compare(supQtyLeft, demQtyLeft, 1.0E-7) == 0) {
                        this.lastSupUsedQty = 0.0;
                        ++this.lastPairedSup;
                        this.lastDemFilledQty = 0.0;
                        ++this.lastPairedDem;
                        continue block0;
                    }
                    this.lastSupUsedQty = 0.0;
                    ++this.lastPairedSup;
                    this.lastDemFilledQty += supQtyLeft;
                    continue block0;
                }
            }
        }

        @Override
        @Nonnull
        public List<Supply> completeSupplies(@Nonnull SupplyFactory supplyFactory) {
            if (this.lastPairedDem == this.demands.size() - 1) {
                return Lists.newArrayList();
            }
            ArrayList<Supply> newSupplies = Lists.newArrayList();
            double minQty = this.material.getMinBatch();
            while (this.lastPairedDem < this.demands.size() - 1) {
                Demand demand = this.demands.get(this.lastPairedDem + 1);
                double qty = demand.getQty() - this.lastDemFilledQty;
                if (qty < minQty) {
                    qty = minQty;
                }
                try {
                    newSupplies.add(this.createSupply(supplyFactory, qty));
                }
                catch (SupplyCreationException e) {
                    log.error("Cannot create supply: {}", (Object)e.getMessage());
                    break;
                }
                this.completeSupPairing();
            }
            return newSupplies;
        }

        protected Supply createSupply(SupplyFactory supplyFactory, double qty) throws SupplyCreationException {
            Supply gorSupply = supplyFactory.createGorSupply((Product)this.material, qty);
            this.addSupply(gorSupply);
            return gorSupply;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Supplies\n");
            this.format(sb, this.supplies, this.demands, this.supToDem);
            sb.append("\nDemands\n");
            this.format(sb, this.demands, this.supplies, this.demToSup);
            return sb.toString();
        }

        private <A, B> void format(StringBuilder sb, List<A> as, List<B> bs, ListMultimap<A, B> aToB) {
            for (int i = 0; i < as.size(); ++i) {
                A a = as.get(i);
                if (i < 9) {
                    sb.append(' ');
                }
                sb.append(i + 1);
                sb.append(". ");
                sb.append(a);
                Collection bs2 = aToB.get((Object)a);
                if (!bs2.isEmpty()) {
                    sb.append(" -> ");
                    for (Object b : bs2) {
                        sb.append(bs.indexOf(b) + 1);
                        sb.append(", ");
                    }
                    sb.setLength(sb.length() - 2);
                }
                sb.append('\n');
            }
        }
    }
}

